---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：23-Point in Time（PIT）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **REST APIエンドポイントパス**：RestCreatePitAction等のコード未精査
  2. **自動期限切れメカニズムの詳細**：SearchService/ReaderContextのコード未参照

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/search/CreatePitAction.java` - アクション名定義
- E-02: `server/src/main/java/org/opensearch/action/search/TransportCreatePitAction.java` - PIT作成ロジック
- E-03: `server/src/main/java/org/opensearch/action/search/CreatePitRequest.java` - リクエスト構造
- E-04: `server/src/main/java/org/opensearch/action/search/PitService.java` - PIT共通サービス
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:data/read/point_in_time/create | E-01 (18行目) | ○ |
| C-02 | keep_aliveは必須 | E-03 (validate, 127-133行目) | ○ |
| C-03 | allow_partial_pit_creationパラメータあり | E-03 (44行目) | ○ |
| C-04 | PublicApi(since = "2.3.0") | E-03 (37行目) | ○ |
| C-05 | toSearchRequest()でSearchRequestに変換 | E-03 (200-207行目) | ○ |
| C-06 | CreatePitControllerに処理委譲 | E-02 (80行目) | ○ |
| C-07 | StepListenerパターンで非同期処理 | E-02 (70-71行目) | ○ |
| C-08 | CreateReaderContextRequestでシャードにコンテキスト作成 | E-02 (91-120行目) | ○ |
| C-09 | PitService.deletePitContextsでノード別削除 | E-04 (70-127行目) | ○ |
| C-10 | ノード不在時はfalseで報告 | E-04 (99-110行目) | ○ |
| C-11 | getIndicesForPitsでPIT IDからインデックス名解決 | E-04 (164-170行目) | ○ |
| C-12 | getAllPitsで全データノードからPIT一覧取得 | E-04 (186-220行目) | ○ |
| C-13 | GroupedActionListenerで結果集約 | E-04 (129-159行目) | ○ |
| C-14 | TransportIndicesResolvingAction実装 | E-02 (38-39行目) | ○ |
| C-15 | REST APIエンドポイントパスの正確性 | **根拠なし** | △ |
| C-16 | 自動期限切れメカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- REST APIエンドポイント：RestCreatePitAction, RestDeletePitAction等のコードを直接参照していない
  - 候補：RestCreatePitAction.java / RestDeletePitAction.java / RestGetAllPitsAction.java
- 自動期限切れ：keep_alive期間経過後のPITコンテキスト自動削除のメカニズム
  - 候補：SearchService.java / ReaderContext.java

## 5) リスクフラグ（レビュー観点）
- 0: REST APIパスの正確性
- 1: 自動期限切れメカニズムの正確な記述

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイントパスの正確性を確認
- [ ] keep_aliveの自動期限切れメカニズムを確認
- [ ] クロスクラスタPITの動作を確認
